/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.common.Mekanism;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TransmitterNetworkRegistry {
    private static final TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private final Set<DynamicNetwork<?, ?, ?>> networks = new ObjectOpenHashSet();
    private final Map<UUID, DynamicNetwork<?, ?, ?>> clientNetworks = new Object2ObjectOpenHashMap();
    private Map<Coord4D, Transmitter<?, ?, ?>> newOrphanTransmitters = new Object2ObjectOpenHashMap();
    private Set<Transmitter<?, ?, ?>> invalidTransmitters = new ObjectOpenHashSet();
    private Set<DynamicNetwork<?, ?, ?>> networksToChange = new ObjectOpenHashSet();

    public void addClientNetwork(UUID networkID, DynamicNetwork<?, ?, ?> network) {
        if (!this.clientNetworks.containsKey(networkID)) {
            this.clientNetworks.put(networkID, network);
        }
    }

    @Nullable
    public DynamicNetwork<?, ?, ?> getClientNetwork(UUID networkID) {
        return this.clientNetworks.get(networkID);
    }

    public void removeClientNetwork(DynamicNetwork<?, ?, ?> network) {
        this.clientNetworks.remove(network.getUUID());
    }

    public void clearClientNetworks() {
        this.clientNetworks.clear();
    }

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.clear();
    }

    public static void invalidateTransmitter(Transmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.add(transmitter);
    }

    public static void registerOrphanTransmitter(Transmitter<?, ?, ?> transmitter) {
        Coord4D coord;
        Transmitter<?, ?, ?> previous;
        if (!TransmitterNetworkRegistry.getInstance().invalidTransmitters.remove(transmitter) && (previous = TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.put(coord = transmitter.getTileCoord(), transmitter)) != null && previous != transmitter) {
            Mekanism.logger.error("Different orphan transmitter was already registered at location! {}", (Object)coord);
        }
    }

    public static void registerChangedNetwork(DynamicNetwork<?, ?, ?> network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.remove(network);
        this.networksToChange.remove(network);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.removeInvalidTransmitters();
            this.assignOrphans();
            this.commitChanges();
            for (DynamicNetwork<?, ?, ?> net : this.networks) {
                net.onUpdate();
            }
        }
    }

    private void removeInvalidTransmitters() {
        if (!this.invalidTransmitters.isEmpty()) {
            Set<Transmitter<?, ?, ?>> toInvalidate = this.invalidTransmitters;
            this.invalidTransmitters = new ObjectOpenHashSet();
            if (MekanismAPI.debug) {
                Mekanism.logger.info("Dealing with {} invalid Transmitters", (Object)toInvalidate.size());
            }
            for (Transmitter<?, ?, ?> invalid : toInvalidate) {
                this.removeInvalidTransmitter(invalid);
            }
        }
    }

    private <NETWORK extends DynamicNetwork<?, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<?, NETWORK, TRANSMITTER>> void removeInvalidTransmitter(Transmitter<?, NETWORK, TRANSMITTER> invalid) {
        NETWORK n;
        if (!(invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null)) {
            ((DynamicNetwork)n).invalidate(invalid);
            if (!invalid.isValid()) {
                invalid.setTransmitterNetwork(null, false);
            }
        }
    }

    private void assignOrphans() {
        if (!this.newOrphanTransmitters.isEmpty()) {
            Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters = this.newOrphanTransmitters;
            this.newOrphanTransmitters = new Object2ObjectOpenHashMap();
            if (MekanismAPI.debug) {
                Mekanism.logger.info("Dealing with {} orphan Transmitters", (Object)orphanTransmitters.size());
            }
            for (Transmitter<?, ?, ?> orphanTransmitter : orphanTransmitters.values()) {
                if (!orphanTransmitter.isValid() || !orphanTransmitter.isOrphan()) continue;
                OrphanPathFinder finder = new OrphanPathFinder(orphanTransmitter);
                this.networksToChange.add((DynamicNetwork<?, ?, ?>)finder.getNetworkFromOrphan(orphanTransmitters));
            }
        }
    }

    private void commitChanges() {
        if (!this.networksToChange.isEmpty()) {
            Set<DynamicNetwork<?, ?, ?>> networks = this.networksToChange;
            this.networksToChange = new ObjectOpenHashSet();
            for (DynamicNetwork<?, ?, ?> network : networks) {
                network.commit();
            }
        }
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public Component[] toComponents() {
        Component[] components = new Component[this.networks.size()];
        int i = 0;
        for (DynamicNetwork<?, ?, ?> network : this.networks) {
            components[i++] = network.getTextComponent();
        }
        return components;
    }

    public static class OrphanPathFinder<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> {
        private final CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> transmitterValidator;
        private final Set<TRANSMITTER> connectedTransmitters = new ObjectOpenHashSet();
        private final Long2ObjectMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
        private final Set<NETWORK> networksFound = new ObjectOpenHashSet();
        private final Set<BlockPos> iterated = new ObjectOpenHashSet();
        private final Deque<BlockPos> queue = new LinkedList<BlockPos>();
        private final TRANSMITTER startPoint;
        private final Level world;

        OrphanPathFinder(Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> start) {
            this.startPoint = start;
            this.world = ((Transmitter)this.startPoint).getTileWorld();
            this.transmitterValidator = ((Transmitter)this.startPoint).getNewOrphanValidator();
        }

        NETWORK getNetworkFromOrphan(Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters) {
            DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> network;
            if (this.queue.peek() != null) {
                Mekanism.logger.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(((Transmitter)this.startPoint).getTilePos());
            while (this.queue.peek() != null) {
                this.iterate(orphanTransmitters, this.queue.removeFirst());
            }
            if (this.networksFound.size() == 1) {
                if (MekanismAPI.debug) {
                    Mekanism.logger.info("Adding {} transmitters to single found network", (Object)this.connectedTransmitters.size());
                }
                network = (DynamicNetwork)this.networksFound.iterator().next();
            } else {
                if (MekanismAPI.debug) {
                    if (this.networksFound.isEmpty()) {
                        Mekanism.logger.info("No networks found. Creating new network for {} transmitters", (Object)this.connectedTransmitters.size());
                    } else {
                        Mekanism.logger.info("Merging {} networks with {} new transmitters", (Object)this.networksFound.size(), (Object)this.connectedTransmitters.size());
                    }
                }
                network = ((Transmitter)this.startPoint).createNetworkByMerging(this.networksFound);
            }
            network.addNewTransmitters(this.connectedTransmitters, this.transmitterValidator);
            return (NETWORK)network;
        }

        private void iterate(Map<Coord4D, Transmitter<?, ?, ?>> orphanTransmitters, BlockPos from) {
            if (this.iterated.add(from)) {
                Coord4D fromCoord = new Coord4D((Vec3i)from, this.world);
                if (orphanTransmitters.containsKey(fromCoord)) {
                    Transmitter<?, ?, ?> transmitter = orphanTransmitters.get(fromCoord);
                    if (transmitter.isValid() && transmitter.isOrphan() && ((Transmitter)this.startPoint).supportsTransmissionType(transmitter) && this.transmitterValidator.isTransmitterCompatible(transmitter)) {
                        this.connectedTransmitters.add(transmitter);
                        transmitter.setOrphan(false);
                        for (Direction direction : EnumUtils.DIRECTIONS) {
                            TileEntityTransmitter tile;
                            BlockPos directionPos = from.m_142300_(direction);
                            if (this.iterated.contains(directionPos) || (tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (LevelAccessor)this.world, this.chunkMap, directionPos)) == null || !transmitter.isValidTransmitterBasic(tile, direction)) continue;
                            this.queue.addLast(directionPos);
                        }
                    }
                } else {
                    Object net;
                    TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (LevelAccessor)this.world, this.chunkMap, from);
                    if (tile != null && ((Transmitter)this.startPoint).supportsTransmissionType(tile) && (net = tile.getTransmitter().getTransmitterNetwork()) != null && this.transmitterValidator.isNetworkCompatible(net)) {
                        this.networksFound.add(net);
                    }
                }
            }
        }
    }
}

